/*
 * SquareMazePrinter2.java
 *
 * Created on April 21, 2003, 12:44 PM
 * 
 * Copyright 2003 Danny Brewer
 * Anyone may run this code.
 * If you wish to modify or distribute this code, then
 *  you are granted a license to do so only under the terms
 *  of the Gnu Lesser General Public License.
 * See:  http://www.gnu.org/licenses/lgpl.html
 */


package nom.DannyBrewer.recreation.squareMaze;


public class SquareMazePrinter2 extends SquareMazePrinter {
	
    //----------------------------------------------------------------------
    //  Constructor
    //----------------------------------------------------------------------
	
	public SquareMazePrinter2( SquareMaze maze ) {
		super( maze );
	}

	
    //----------------------------------------------------------------------
    //  SquareMazePrinter implementation
    //----------------------------------------------------------------------
	
	// Print the wall that borders the top or bottom of a cell.
	protected void printHorizWall( boolean wall, boolean solution ) {
		if( wall ) {
			System.out.print( (char) 196 );
			System.out.print( (char) 196 );
		} else if( solution ) {
			System.out.print( "**" );
		} else {
			System.out.print( "  " );
		}
	}
	
	// Print the wall that borders the left or right of a cell.
	protected void printVertWall( boolean wall, boolean solution ) {
		if( wall ) {
			System.out.print( (char) 179 );
		} else if( solution ) {
			System.out.print( "*" );
		} else {
			System.out.print( " " );
		}
	}
		
	// Print one character at the intersection of vertical and horizontal walls.
	// The four parameters indicate which parts of the cross should be printed.
	protected void printCross( boolean top, boolean left, boolean bottom, boolean right ) {
		int v = 0;
		if( top ) v += 1;
		if( left ) v += 2;
		if( bottom ) v += 4;
		if( right ) v += 8;
		
		switch( v ) {
			case 1:		v = 179;		break;
			case 2:		v = 196;		break;
			case 3:		v = 217;		break;
			case 4:		v = 179;		break;
			case 5:		v = 179;		break;
			case 6:		v = 171;		break;
			case 7:		v = 180;		break;
			case 8:		v = 196;		break;
			case 9:		v = 192;		break;
			case 10:	v = 196;		break;
			case 11:	v = 193;		break;
			case 12:	v = 218;		break;
			case 13:	v = 195;		break;
			case 14:	v = 194;		break;
			case 15:	v = 197;		break;
			default:	v = 0;
		}

		if( v == 0 ) {
			System.out.print( " " );
		} else {
			System.out.print( (char) v );
		}
	}
	
	// Print the contents of a cell inside its walls.
	protected void printInnerCell( boolean solution ) {
		if( solution ) {
			System.out.print( "**" );
		} else {
			System.out.print( "  " );
		}
	}

	
    //----------------------------------------------------------------------
    //  Test routine
    //----------------------------------------------------------------------
	
	public static void main( String[] args ) {
		SquareMaze maze = new SquareMaze( 10, 15 );
		SquareMazeGenerator1 mazeGen = new SquareMazeGenerator1( maze );
		mazeGen.generateMaze();
		
		SquareMazePrinter mazePrinter = new SquareMazePrinter2( maze );
		mazePrinter.printMaze( true );
	}

} // class SquareMazePrinter2

